/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.roughlyenoughprofessions.rei;

import com.mrbysco.roughlyenoughprofessions.compat.CompatibilityHelper;
import com.mrbysco.roughlyenoughprofessions.platform.Services;
import com.mrbysco.roughlyenoughprofessions.profession.ProfessionEntry;
import com.mrbysco.roughlyenoughprofessions.rei.ProfessionCategory;
import com.mrbysco.roughlyenoughprofessions.rei.ProfessionDisplayForge;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.LinkedList;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPlugin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

@REIPlugin
public class REPClientPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<ProfessionDisplayForge> PROFESSION = CategoryIdentifier.of((String)"roughlyenoughprofessions", (String)"plugins/profession");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new ProfessionCategory());
        registry.addWorkstations(PROFESSION, new EntryStack[]{EntryStacks.of((ItemLike)Items.f_42616_), EntryStacks.of((ItemLike)Items.f_42601_)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        LinkedList<ProfessionEntry> entries = new LinkedList<ProfessionEntry>();
        for (VillagerProfession profession : ForgeRegistries.PROFESSIONS) {
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            PoiType poiType = profession.m_35622_();
            for (BlockState state : poiType.f_27325_) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(state.m_60734_().getRegistryName());
                if (block == null) continue;
                ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), Services.PLATFORM.getProfessionID(profession));
                ResourceLocation location = stack.m_41720_().getRegistryName();
                if (stack.m_41619_() || knownItems.contains(location)) continue;
                stacks.add(stack);
                knownItems.add(location);
            }
            if (stacks.isEmpty()) continue;
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            for (int i = 0; i < stacks.size(); ++i) {
                map.put(i, (Object)((ItemStack)stacks.get(i)));
            }
            entries.add(new ProfessionEntry(profession, (Int2ObjectMap<ItemStack>)map));
        }
        entries.forEach(entry -> registry.add((Display)new ProfessionDisplayForge((ProfessionEntry)entry)));
    }
}

